-- name: Custom Sound Replacement

-- Toggles
-- Set to true if you you want to disable default red coin sound
local REPLACE_RED_COIN = false

-- Define sounds here
local nihaha1 = audio_sample_load("koyuki_jump1.mp3")
local nihaha2 = audio_sample_load("koyuki_longjump.mp3")
local koyuki_bonk = audio_sample_load("koyuki_bonk.mp3")
local nihaha3 = audio_sample_load("koyuki_laugh1.mp3")
-- local sonic_ring = audio_sample_load("sonic_ring.mp3")

-- Red coin sounds and all the 8 pitches
-- Don't modify this table
local RED_COIN_TABLE = {
  [SOUND_MENU_COLLECT_RED_COIN] = true,
  [SOUND_MENU_COLLECT_RED_COIN + 0x10000] = true,
  [SOUND_MENU_COLLECT_RED_COIN + 0x20000] = true,
  [SOUND_MENU_COLLECT_RED_COIN + 0x30000] = true,
  [SOUND_MENU_COLLECT_RED_COIN + 0x40000] = true,
  [SOUND_MENU_COLLECT_RED_COIN + 0x50000] = true,
  [SOUND_MENU_COLLECT_RED_COIN + 0x60000] = true,
  [SOUND_MENU_COLLECT_RED_COIN + 0x70000] = true,
}

-- The NPC sound replacement table,
-- Key is the soundBit index
-- Value is a table that contains 1 or more of the sounds defined
-- If the value is nil then the replacement is ignored
-- Follow the link for a list of sound constants that can be used
-- https://github.com/coop-deluxe/sm64coopdx/blob/main/docs/lua/constants.md#sounds.h
local CUSTOM_SOUND_TABLE = {
  -- Ukiki
  [SOUND_OBJ_UKIKI_CHATTER_LONG] = { nihaha2 }, -- Long Hop (Slower interval)
  [SOUND_OBJ_UKIKI_CHATTER_SHORT] = { nihaha3 },         -- Short Hops (Faster interval)
  [SOUND_OBJ_UKIKI_CHATTER_IDLE] = { nihaha1 },                       -- Handstand (Plays once)
  -- Bowser
  [SOUND_OBJ_BOWSER_INTRO_LAUGH] = nil,
  [SOUND_OBJ_BOWSER_LAUGH] = nil,
  [SOUND_OBJ_BOWSER_INHALING] = nil,
  [SOUND_OBJ_BOWSER_TAIL_PICKUP] = nil,
  [SOUND_OBJ_BOWSER_DEFEATED] = nil,
  [SOUND_OBJ2_BOWSER_ROAR] = nil,
  -- Add other NPCS as needed
  [SOUND_GENERAL_COIN] = nil,
  [SOUND_GENERAL_RED_COIN] = nil,
  [SOUND_MENU_COLLECT_RED_COIN] = nil
}

---Play custom Sound
---@param soundBits integer
---@param pos Vec3f
local function on_play_sound(soundBits, pos)
  -- Disable red coin sound
  -- this matches any red coin from 1 to 8
  if REPLACE_RED_COIN and RED_COIN_TABLE[soundBits] then
    return NO_SOUND
  end
  -- Check if the current sound is in the sound replacement table
  local npcSound = CUSTOM_SOUND_TABLE[soundBits]
  if npcSound ~= nil then
    local index = math.random(#npcSound)
    audio_sample_play(npcSound[index], pos, 1.0)
    return NO_SOUND
  end
end


hook_event(HOOK_ON_PLAY_SOUND, on_play_sound)
